/* ------------------------------------------------------------------------ */
/*  @@ Source Documentation                        *** MSC/TC Version ***   */
/*                                                                          */
/*  Copyright (c) Creative Technology Pte Ltd, 1991. All rights reserved.   */
/*                                                                          */
/*   TITLE       : MIDIOUT.C                                                */
/*                                                                          */
/*   DESCRIPTION :                                                          */
/*       This program demostrates how to use the SBK MIDI interface         */
/*       functions to play a 'C major scale'. It calls the MIDI low         */
/*       level interface functions to send the MIDI commands to MIDI        */
/*       keyboard.                                                          */
/*                                                                          */
/*       The program checks BLASTER environment for the Card settings.      */
/*       It also performs test base on BLASTER environment settings to      */
/*       ensure they are tally with the hardware settings on the Card.      */
/*                                                                          */
/* ------------------------------------------------------------------------ */

#include <stdio.h>
#include <sbc.h>
#include <sbmidi.h>


/* Look up table for MIDI value of a 'scale' starts from 'middle C' */

unsigned char  NoteNum[] = { 60, 62, 64, 65, 67, 69, 71, 72 } ;



#pragma loop_opt(off)
main ()
{
    unsigned int   i, j, note;
    unsigned char  pnum;


    /* Retrieve the BLASTER environment settings */
    if ( ! GetEnvSetting() )
    {
        if (sbc_check_card() & 4)
        {
            for ( pnum= 0; pnum < 5; pnum++ )
            {
                /* program change command */
                sbmidi_out_shortmsg( 0xC0, pnum, 0 );

                /* play the Middle C scale */
                for ( note=0; note < 8; note++ )
                {
                    /* Note On command */
                    sbmidi_out_shortmsg( 0x90, NoteNum[note], 0x40 );

                    /* delay loop */
                    for (i=0; i<100; i++)
                        for (j=0; j < 1000; j++);

                    /* Note Off command */
                    sbmidi_out_shortmsg( 0x80, NoteNum[note], 0x40 );
                }
            }
        }
        else
            printf("Sound Blaster Card not found or wrong I/O settings.\n") ;
    }
    else
        printf("BLASTER environment not set or incomplete or invalid.\n");
}
#pragma loop_opt()
